/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreActivity;
import java.util.Queue;

final class PairingQueue {
    private double posRem;
    private double negRem;
    private double posPart;
    private double negPart;
    private final Queue<StoreActivity> posQueue;
    private final Queue<StoreActivity> negQueue;
    private final Table<Material, StoreActivity, Double> overridingPairing;
    private final Table<Material, StoreActivity, Double> targetPairing;

    PairingQueue(Table<Material, StoreActivity, Double> overridingPairing, Table<Material, StoreActivity, Double> targetPairing) {
        this.overridingPairing = overridingPairing;
        this.targetPairing = targetPairing;
        this.posQueue = Lists.newLinkedList();
        this.negQueue = Lists.newLinkedList();
    }

    public void addOverriding(StoreActivity sa) {
        double qty = sa.getQty();
        if (qty < 0.0) {
            this.negRem += qty;
            if (this.negQueue.isEmpty()) {
                this.negPart = sa.getQty();
            }
            this.negQueue.add(sa);
        } else {
            this.posRem += qty;
            if (this.posQueue.isEmpty()) {
                this.posPart = sa.getQty();
            }
            this.posQueue.add(sa);
        }
    }

    public boolean hasSomethingFor(double qty) {
        return qty < 0.0 && this.negRem < -1.0E-7 || qty > 0.0 && this.posRem > 1.0E-7;
    }

    public double pairTarget(StoreActivity sa) {
        double qty = sa.getQty();
        double res = 0.0;
        if (qty < 0.0) {
            if (qty <= this.negRem) {
                StoreActivity oSa;
                while ((oSa = this.negQueue.poll()) != null) {
                    this.overridingPairing.put(oSa.getMaterial(), oSa, oSa.getQty());
                }
                this.targetPairing.put(sa.getMaterial(), sa, this.negRem);
                res = qty - this.negRem;
                this.negPart = 0.0;
                this.negRem = 0.0;
            } else {
                while (qty < -1.0E-7 && this.negPart < -1.0E-7) {
                    if (this.negPart < qty) {
                        this.negPart -= qty;
                        this.negRem -= qty;
                        qty = 0.0;
                        continue;
                    }
                    qty -= this.negPart;
                    this.negRem -= this.negPart;
                    StoreActivity oSa = this.negQueue.remove();
                    this.overridingPairing.put(oSa.getMaterial(), oSa, oSa.getQty());
                    oSa = this.negQueue.peek();
                    this.negPart = oSa == null ? 0.0 : oSa.getQty();
                }
                this.targetPairing.put(sa.getMaterial(), sa, sa.getQty());
                res = 0.0;
            }
        } else if (qty >= this.posRem) {
            StoreActivity oSa;
            while ((oSa = this.posQueue.poll()) != null) {
                this.overridingPairing.put(oSa.getMaterial(), oSa, oSa.getQty());
            }
            this.targetPairing.put(sa.getMaterial(), sa, this.posRem);
            res = qty - this.posRem;
            this.posPart = 0.0;
            this.posRem = 0.0;
        } else {
            while (qty > 1.0E-7 && this.posPart > 1.0E-7) {
                if (this.posPart > qty) {
                    this.posPart -= qty;
                    this.posRem -= qty;
                    qty = 0.0;
                    continue;
                }
                qty -= this.posPart;
                this.posRem -= this.posPart;
                StoreActivity oSa = this.posQueue.remove();
                this.overridingPairing.put(oSa.getMaterial(), oSa, oSa.getQty());
                oSa = this.posQueue.peek();
                this.posPart = oSa == null ? 0.0 : oSa.getQty();
            }
            this.targetPairing.put(sa.getMaterial(), sa, sa.getQty());
            res = 0.0;
        }
        return res;
    }

    public void flush() {
        StoreActivity sa;
        if (this.posPart > 1.0E-7) {
            sa = this.posQueue.remove();
            this.overridingPairing.put(sa.getMaterial(), sa, sa.getQty() - this.posPart);
        }
        while ((sa = this.posQueue.poll()) != null) {
            this.overridingPairing.put(sa.getMaterial(), sa, 0.0);
        }
        if (this.negPart < -1.0E-7) {
            sa = this.negQueue.remove();
            this.overridingPairing.put(sa.getMaterial(), sa, sa.getQty() - this.negPart);
        }
        while ((sa = this.negQueue.poll()) != null) {
            this.overridingPairing.put(sa.getMaterial(), sa, 0.0);
        }
    }
}

